% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lithlog_disc.R
\name{lithlog_disc}
\alias{lithlog_disc}
\title{Discriticizes lithologs}
\usage{
lithlog_disc(
  litholog = NULL,
  subset_fact = 100,
  lin_interp = FALSE,
  dt = NULL,
  genplot = FALSE,
  x_lab = "rank",
  y_lab = "depth (m)",
  keep_editable = FALSE
)
}
\arguments{
\item{litholog}{litholog input matrix with 3 columns column 1 is bottom of the bed,
column 2 is top of bed, column is depth rank/proxy value}

\item{subset_fact}{subset factor which is x times the greatest common divider \code{Default=100}.}

\item{lin_interp}{Linear interpolation of the data set \code{Default=FALSE}}

\item{dt}{step size  \code{Default=NULL}.}

\item{genplot}{generate plot  \code{Default=FALSE}}

\item{x_lab}{label for the y-axis \code{Default="rank"}}

\item{y_lab}{label for the y-axis \code{Default="depth (m)"}}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
Returns a matrix with 2 columns, the first column is depth the second columns is the depth/rank proxy
If genplot is \code{Default=TRUE} then a plot of the discriticizes time series is plotted
}
\description{
Discriticizes lithologs to allow further time-series analysis first the
Greatest common divisor/highest common factor is calculated which is then used to discriticize
the litholog to an evenly sampled data series. The function is designed to place the boundary
at the original depth level of the bed boundaries. The Greatest common divisor/highest common factor can
be a very small number as such the discriticized data set can be large which impacts computational
performance later on therefore a linear interpolation option is added to downscale the data to allow
for computational efficiency later on. This is made to discriticize lithologs created using the
'StratigrapheR' package. as such the same data format for input is used.
eg. column 1 is bottom of the bed, column 2 is top of bed, column is depth rank/proxy value
}
\examples{
# Convert depth rank record to a discrete proxy record to allow for further
# analysis in which discrete time series are needed
depth_rank_example_disc <- lithlog_disc(litholog = depth_rank_example,
           subset_fact = 100,
           genplot = FALSE,
           x_lab = "rank",
           y_lab = "depth (m)",
           keep_editable=FALSE)


}
\references{
Wouters, S., Da Silva, A.-C., Boulvain, F., and Devleeschouwer, X.. 2021.
StratigrapheR: Concepts for Litholog Generation in R.
The R Journal. <\doi{doi:10.32614/RJ-2021-039}>
}
