% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterMLVersion.R
\name{WaterMLVersion}
\alias{WaterMLVersion}
\title{WaterMLVersion}
\usage{
WaterMLVersion(doc)
}
\arguments{
\item{doc}{The XML document object}
}
\value{
A character with the WaterML version: either 1.0, 1.1, or 2.0
}
\description{
A helper function that finds out the WaterML version from
the WaterML document. By default it checks for "http://www.opengis.net/waterml/2.0"
Otherwise it tries to detect "http://www.cuahsi.org/waterML/1.1/" (for WaterML 1.1) or
"http://www.cuahsi.org/WaterML/1.0/" (for WaterML 1.0)
}
\examples{
library(httr)
library(XML)
url <- "http://www.waterml2.org/KiWIS-WML2-Example.wml"
response <- GET(url)
doc <- xmlParse(response)
version <- WaterMLVersion(doc)
}
\keyword{WaterML}

