% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GainCurve.R
\name{GainCurvePlot}
\alias{GainCurvePlot}
\title{Plot the gain curve of a sort-order.}
\usage{
GainCurvePlot(frame, xvar, truthVar, title, ...)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}
}
\description{
Plot the gain curve of a sort-order.
}
\examples{

set.seed(34903490)
y = abs(rnorm(20)) + 0.1
x = abs(y + 0.5*rnorm(20))
frm = data.frame(model=x, value=y)
frm$costs=1
frm$costs[1]=5
frm$rate = with(frm, value/costs)
frm$isValuable = (frm$value >= as.numeric(quantile(frm$value, probs=0.8)))
WVPlots::GainCurvePlot(frm, "model", "value",
   title="Example Continuous Gain Curve")

}

