% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasplot.R
\name{seasplot}
\alias{seasplot}
\alias{seasplot.tidal}
\alias{seasplot.tidalmean}
\title{Plot seasonal trends across all years}
\usage{
seasplot(dat_in, ...)

\method{seasplot}{tidal}(dat_in, tau = NULL, predicted = TRUE, span = 0.4,
  lwd = 1, size = 2, alpha = 1, col_vec = NULL, grids = TRUE,
  logspace = TRUE, ...)

\method{seasplot}{tidalmean}(dat_in, predicted = TRUE, span = 0.4,
  lwd = 1, size = 2, alpha = 1, col_vec = NULL, grids = TRUE,
  logspace = TRUE, ...)
}
\arguments{
\item{dat_in}{Input data object}

\item{...}{arguments passed to other methods}

\item{tau}{numeric of quantile to plot}

\item{predicted}{logical indicating if seasonal smooth is based on model predictions, default \code{TRUE}, otherwise the smooth is based on flow-normalized predictions}

\item{span}{numeric indicating the smoothing parameter for the loess fit, passed to \code{\link[ggplot2]{stat_smooth}}}

\item{lwd}{numeric value indicating width of lines}

\item{size}{numeric value indicating size of points}

\item{alpha}{numeric value indicating transparency of points or lines}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}}.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{grids}{logical indicating if grid lines are present}

\item{logspace}{logical indicating if plots are in log space}
}
\description{
Plot seasonal trends by combining annual data
}
\details{
Seasonal variation across all years can be viewed by showing the observed annual data on a common y-axis.  The year value is removed from the results such that the y-axis shows only the day of the year.  A simple loess (locally estimated) polynomial smooth is added to show the seasonal trend in the results, where the smoother is fit through the model results for the observed data.  The fit can be smoothed through the model predictions or the flow-normalized predictions, neither of which are shown on the plot.
}
\examples{
# load a fitted tidal object
data(tidfit)

# plot using defaults
# defaults to all quantiles for tidal object
seasplot(tidfit)

# tidalmean object
seasplot(tidfitmean)
}
\seealso{
\code{\link{dynaplot}}, \code{\link{fitmoplot}}, \code{\link{gridplot}}, and \code{\link{sliceplot}} produce similar graphics except variation in the same month across years is emphasized.
}
