% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculator_f.R
\name{cond_mvn}
\alias{cond_mvn}
\title{Calculate conditional multivariate normal values}
\usage{
cond_mvn(mu, Sigma, i, xi, full_output = FALSE)
}
\arguments{
\item{mu}{mean vector}

\item{Sigma}{covariance matrix}

\item{i}{index of the known parameter (1-based index)}

\item{xi}{known value of the i-th parameter}

\item{full_output}{boolean indicating whether to return the full list of parameters}
}
\value{
List of length 2, one with new mu and other with covariance parameters
}
\description{
Calculate conditional multivariate normal values
}
\details{
Function to compute conditional multivariate normal values
}
\examples{
mu <- c(1, 2, 3)
Sigma <- matrix(c(0.2, 0.05, 0.1, 
                  0.05, 0.3, 0.05, 
                  0.1, 0.05, 0.4), nrow = 3)

i <- 1:2  # Index of the known parameter
xi <- c(1.2,2.3)  # Known value of the first parameter

cond_mvn(mu, Sigma, i, xi,full_output = TRUE)
}
