% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_no.R
\name{form.no}
\alias{form.no}
\title{Calculate tidal form number}
\usage{
form.no(station)
}
\arguments{
\item{station}{station ID number or vector of IDs, available on CO-OPS 
website (\url{https://www.tidesandcurrents.noaa.gov/stations.html?type=Water+Levels}).}
}
\value{
a dataframe of station number(s) and corresponding tidal form number(s).
}
\description{
Uses harmonic constituent data from the NOAA 
CO-OPS website to calculate tidal form numbers as the ratio 
of the sum of K1 and O1 diurnal harmonic constituent amplitudes 
to the sum of the M2 and S2 semidiurnal amplitudes. Requires 
an internet connection.
}
\examples{
\dontrun{
a <- form.no()
stn.list <- c("8467150", "8461490", "9454240")
b <- form.no(stn.list)
b
} 
}
