% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_summary.R
\name{summary.visitation_forecast}
\alias{summary.visitation_forecast}
\title{visitation_forecast Summary Method}
\usage{
\method{summary}{visitation_forecast}(object, ...)
}
\arguments{
\item{object}{An object of class "decomposition".}

\item{...}{Additional arguments.}
}
\value{
A "decomposition" class object.
}
\description{
Methods for summarizing objects of the class "decomposition".
}
\examples{
#Example:

data("park_visitation")
data("flickr_userdays")

n_ahead <- 12
park <- "YELL"
pud_ts <- ts(park_visitation[park_visitation$park == park,]$pud, start = 2005, freq = 12)
pud_ts <- log(pud_ts)
trend_proxy <- log(flickr_userdays)

mf <- visitation_model(pud_ts,trend_proxy)
vf <- predict(mf,12, only_new = FALSE)
summary(vf)
}
