% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_prep_object.R
\name{copulaFromFamilyIndex}
\alias{copulaFromFamilyIndex}
\title{Construction of a Copula Object from a VineCopula Family Index}
\usage{
copulaFromFamilyIndex(family, par, par2 = 0)
}
\arguments{
\item{family}{a family index as defined in \code{\link{VineCopula-package}}}

\item{par}{its first parameter value}

\item{par2}{if present, its second parameter}
}
\value{
An object inherting \code{\linkS4class{copula}} corresponding to the
specific family.
}
\description{
A VineCopula family index along with its parameters is used to construct a
corresponding \code{\linkS4class{copula}} object.
}
\examples{

# normalCopula with parameter 0.5
copulaFromFamilyIndex(1, 0.5)

# rotated Tawn T2 copula with parameters
copulaFromFamilyIndex(224, -2, 0.5)

}
\author{
Benedikt Graeler
}
