% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCop.R
\name{BiCop}
\alias{BiCop}
\title{Constructing BiCop-objects}
\usage{
BiCop(family, par, par2 = 0, tau = NULL, check.pars = TRUE)
}
\arguments{
\item{family}{An integer defining the bivariate copula family: \cr
\code{0} = independence copula \cr
\code{1} = Gaussian copula \cr
\code{2} = Student t copula (t-copula) \cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr
\code{5} = Frank copula \cr
\code{6} = Joe copula \cr
\code{7} = BB1 copula \cr
\code{8} = BB6 copula \cr
\code{9} = BB7 copula \cr
\code{10} = BB8 copula \cr
\code{13} = rotated Clayton copula (180 degrees; ``survival Clayton'') \cr
\code{14} = rotated Gumbel copula (180 degrees; ``survival Gumbel'') \cr
\code{16} = rotated Joe copula (180 degrees; ``survival Joe'') \cr
\code{17} = rotated BB1 copula (180 degrees; ``survival BB1'')\cr
\code{18} = rotated BB6 copula (180 degrees; ``survival BB6'')\cr
\code{19} = rotated BB7 copula (180 degrees; ``survival BB7'')\cr
\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
\code{23} = rotated Clayton copula (90 degrees) \cr
\code{24} = rotated Gumbel copula (90 degrees) \cr
\code{26} = rotated Joe copula (90 degrees) \cr
\code{27} = rotated BB1 copula (90 degrees) \cr
\code{28} = rotated BB6 copula (90 degrees) \cr
\code{29} = rotated BB7 copula (90 degrees) \cr
\code{30} = rotated BB8 copula (90 degrees) \cr
\code{33} = rotated Clayton copula (270 degrees) \cr
\code{34} = rotated Gumbel copula (270 degrees) \cr
\code{36} = rotated Joe copula (270 degrees) \cr
\code{37} = rotated BB1 copula (270 degrees) \cr
\code{38} = rotated BB6 copula (270 degrees) \cr
\code{39} = rotated BB7 copula (270 degrees) \cr
\code{40} = rotated BB8 copula (270 degrees) \cr
\code{104} = Tawn type 1 copula \cr
\code{114} = rotated Tawn type 1 copula (180 degrees) \cr
\code{124} = rotated Tawn type 1 copula (90 degrees) \cr
\code{134} = rotated Tawn type 1 copula (270 degrees) \cr
\code{204} = Tawn type 2 copula \cr
\code{214} = rotated Tawn type 2 copula (180 degrees) \cr
\code{224} = rotated Tawn type 2 copula (90 degrees) \cr
\code{234} = rotated Tawn type 2 copula (270 degrees) \cr}

\item{par}{Copula parameter.}

\item{par2}{Second parameter for bivariate copulas with two parameters (t,
BB1, BB6, BB7, BB8, Tawn type 1 and type 2; default is \code{par2 = 0}).
\code{par2} should be an positive integer for the Students's t copula
\code{family = 2}.}

\item{tau}{numeric; value of Kendall's tau; has to lie in the interval
(-1, 1). Can only be used with one-parameter families and the t copula.
If \code{tau} is provided, \code{par} will be ignored.}

\item{check.pars}{logical; default is \code{TRUE}; if \code{FALSE}, checks
for family/parameter-consistency are ommited (should only be used with
care).}
}
\value{
An object of class \code{\link{BiCop}}. It is a list containing
information about the bivariate copula. Its components are:
\item{family, par, par2}{copula family number and parameter(s),}
\item{npars}{number of parameters,}
\item{familyname}{name of the copula family,}
\item{tau}{Kendall's tau,}
\item{beta}{Blomqvist's beta,}
\item{taildep}{lower and upper tail dependence coefficients,}
\item{call}{the call that created the object.}
Objects of this class are also returned by the \code{\link{BiCopEst}} and
\code{\link{BiCopSelect}} functions. In this case, further information about
the fit is added.
}
\description{
This function creates an object of class \code{BiCop} and checks for
family/parameter consistency.
}
\note{
For a comprehensive summary of the model, use \code{summary(object)};
to see all its contents, use \code{str(object)}.
}
\examples{

## create BiCop object for bivariate t-copula
obj <- BiCop(family = 2, par = 0.4, par2 = 6)
obj

## see the object's content or a summary
str(obj)
summary(obj)

## a selection of functions that can be used with BiCop objects
simdata <- BiCopSim(300, obj)  # simulate data
BiCopPDF(0.5, 0.5, obj) # evaluate density in (0.5,0.5)
plot(obj)  # surface plot of copula density
contour(obj)  # contour plot with standard normal margins
print(obj)  # brief overview of BiCop object
summary(obj)  # comprehensive overview of BiCop object

}
\author{
Thomas Nagler
}
\seealso{
\code{\link{BiCopPDF}},
\code{\link{BiCopHfunc}},
\code{\link{BiCopSim}},
\code{\link{BiCopEst}},
\code{\link{BiCopSelect}},
\code{\link{plot.BiCop}},
\code{\link{contour.BiCop}}
}

