% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking.R
\name{check_time_series}
\alias{check_time_series}
\title{Check the new time series}
\usage{
check_time_series(data, ReturnData = FALSE)
}
\arguments{
\item{data}{A data table object output by \code{\link{create_time_series}}.}

\item{ReturnData}{A logical indicating whether to return a data table 
containing Start Time information for each event.}
}
\value{
The value(s) of Time (in milliseconds) at which events begin relative 
to the onset of the auditory stimulus.
}
\description{
\code{check_time_series} examines the first value in the Time column
for each event. If they are equal, it will return a single value.  The returned
value(s) will vary depending on the interest period (if defined), message 
alignment (if completed), and the Adjustment parameter (`Adj`) supplied to 
\code{\link{create_time_series}}. Optionally, the result can be output to a 
dataframe containing all event-level information.
}
\examples{
\dontrun{
library(VWPre)
# Check the starting Time column...
check_time_series(data = dat)
}
}
