% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{prep_data}
\alias{prep_data}
\title{Check the classes of specific columns and re-assigns as necessary.}
\usage{
prep_data(data = data, Subject = Subject, Item = NA,
  EventColumns = c("Subject", "TRIAL_INDEX"))
}
\arguments{
\item{data}{A data frame object created from an Eyelink Sample Report.}

\item{Subject}{An obligatory string containing the column name corresponding to the subject identifier.}

\item{Item}{An optional string containing the column name corresponding to the item identifier; by default, NA.}

\item{EventColumns}{A vector specifying the columns which will be used for creating 
the Event variable; by default, Subject and TRIAL_INDEX.}
}
\value{
An object of type data table as described in \link[dplyr]{tbl_df}.
}
\description{
\code{prep_data} converts the data frame to a data table and examines the 
class of the following columns: Subject, Item, LEFT_INTEREST_AREA_ID, 
RIGHT_INTEREST_AREA_ID, LEFT_INTEREST_AREA_LABEL, RIGHT_INTEREST_AREA_LABEL, 
TIMESTAMP, and TRIAL_INDEX. If they were not encoded with the correct 
class upon importing the data, the function will reassign the class and print 
a summary of the reassignments. Additionally, the data table output by 
the function contains a new column called Event which indexes each unique 
series of samples corresponding to the combination of Subject and 
TRIRAL_Index, necessary for performing subsequent operations.
}
\examples{
\dontrun{
# Typical DataViewer output contains a column called "RECORDING_SESSION_LABEL"
# corresponding to the subject.
# To prepare the data...
library(VWPre)
df <- prep_data(data = dat, Subject = "RECORDING_SESSION_LABEL", Item = "itemID")
}
}

