% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{create_binomial}
\alias{create_binomial}
\title{Creates a success/failure column for each IA based on counts.}
\usage{
create_binomial(data = data, NoIA = NoIA)
}
\arguments{
\item{data}{A data table object output by either \code{\link{bin_prop}} or
\code{\link{transform_to_elogit}}.}

\item{NoIA}{A positive integer indicating the number of interest areas defined 
when creating the study.}
}
\value{
A data table with additional columns (the number of which depends on 
the number of interest areas specified) added to \code{data}.
}
\description{
\code{create_binomial} uses interest area count columns to create 
a success/failure column for each IA which is suitable for logistic regression. 
N.B.: This function will work for data with a maximum of 8 interest areas.
}
\examples{
\dontrun{
library(VWPre)
# Create binomial (success/failure) column...
df <- create_binomial(data = dat, NoIA = 4)
}
}

