% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colplotcode.R
\name{colplot}
\alias{colplot}
\alias{colplot.coxph}
\alias{colplot.default}
\alias{colplot.glm}
\alias{colplot.ksvm}
\alias{colplot.multinom}
\title{Visualize a risk prediction model by means of colored bars.}
\usage{
colplot(x, filename, coloroptions = 2, zerolevel = "zero", risklabel, xmin,
  xmax, adverse, obs, q5, q95, time)
}
\arguments{
\item{x}{\code{glm}, \code{coxph}, \code{mfp}, \code{multinom} or \code{ksvm} object.}

\item{filename}{The name of the resulting file (default: colplot).}

\item{coloroptions}{If 1, the rainbow color map is used.  If 2, a sequential color map is used.  If 3, a diverging color map is used. 
If 4, a black-and-white color map is used. If 5, the viridis color map is used. (default=2)}

\item{zerolevel}{The value of the contributions that should be put to zero.  If "zero", the contributions are represented 
   as they are.  If "min", for each predictor or set of predictors contributing to an interaction, the minimal observed value 
   of the contribution in the training data is substracted from the contribution to ensure that the contribution is always positive.  
If "median" or "mean", the median or mean value is substracted from the contributions, respectively (default="zero").  See below for more details.}

\item{risklabel}{A character string representing the label for the represented risk. For  multinomial logistic regression models, a vector of risk labels should be provided. 
See the examples for an illustration of the approach.}

\item{xmin}{Minimal values of input variables to be represented on the visualization.  These values only have an influence on continuous input variables.}

\item{xmax}{Maximal values of input variables to be represented on the visualization.  These values only have an influence on continuous input variables.}

\item{adverse}{A logical indicating whether the score and risk range in the adverse direction (default=FALSE, i.e. high score corresponds to a high risk).}

\item{obs}{A data.frame containing the predictor values of the observation that should be added to the plot.}

\item{q5}{A data.frame containing the predictor values of the 5th percentiles of the predictors that should be added to the plot. This only impacts the plot for continous variables.}

\item{q95}{A data.frame containing the predictor values of the 95th percentiles of the predictors that should be added to the plot. This only impacts the plot for continous variables.}

\item{time}{The time at which the estimated survival should be calculated.  As default, the estimated survival at median survival time is reported.  If the median 
survival time can not be calculated, the estimated survival at the latest event time is reported.  For objects that are not a member of the \code{coxph} class, this is redundant.}
}
\description{
Display a graph (color based nomogram) in which the contributions of each predictor or set of predictors is represented in a colored bar.  
	The color indicates the value of the contribution.
}
\details{
The colorplot is a chart (similar to a nomogam) that visualizes the contribution of a predictor or a set of predictors by means of 
	colored bars.  Depending on the value of \code{zerolevel}, the visualized contributions are slightly different.  
	If \code{zerolevel}="zero", the contribution for variable \eqn{x^p} is \eqn{\beta_pf_p(x^p)}, with \eqn{\beta_p} the model
	coefficient corresponding to this predictor and \eqn{f_p(x^p)} a (possible) transformation of \eqn{x^p}.  If \code{zerolevel} is "min", "median" or "mean", a value equal to 
	the minimum, median and mean of the contribution \eqn{\beta_pf_p(x^p)} in the training data, respectively, is substracted from the contribution.  See the references for more information.
	\code{coloroptions} enables to choose between diffent color maps.  It is recommended to use the sequential or the viridis color map when \code{zerolevel}="min" 
	and a diverging color map when \code{zerolevel} is "median" or "mean".  For the latter case, a white color will correspond 
	to zero points.  In the color bar converting the score to a risk, white will correspond to the median or mean observed risk 
	in the training data, respectively.
}
\note{
This graph can not be used for cox proportional hazard regression including strata.

For \code{coxph} models, it is necessary to include \code{model=TRUE} in the model fit.

For \code{multinom} models, it is necessary to include \code{model=TRUE} in the model fit.

For \code{multinom} models, more than one output file is generated.  A first series of plots visualizes how the linear predictors are obtained.  The files
	are named "filename_outcome_level", with "outcome_level" the name of the outcome level for which the linear predictor is visualized.  A second series of plots
	visualizes how the linear predictors are transformed into a risk prediction for each outcome level.  The files are named "filename_p_outcome_level".  A third 
	series of plots uses an alternative way to represent the calculation of the risk of the non-reference outcome levels.  These plots are named "filename_outcome_level_wing".

For \code{multinom} models,  a vector of risk labels needs to be made and provided to the \code{colplot()} function.  See the examples for an illustration of the approach.

For \code{ksvm} models, it is necessary to include \code{prob.model=TRUE} in the model fit.

The plot is not shown in a graphical window but saved in the current working directory.
}
\examples{
# default options
mydata <- read.csv("https://stats.idre.ucla.edu/stat/data/binary.csv")
mydata$rank <- factor(mydata$rank)
fit <- glm(admit ~ gre + gpa + rank, data = mydata, family = "binomial")
colplot(fit)

#### cox proportional hazard regression
library(mfp)
data(GBSG)
fit<-coxph(Surv(rfst, cens) ~ age+tumsize+posnodal+prm+esm+menostat+tumgrad, data = GBSG, 
		model=TRUE)
colplot(fit)

#### multinomial logistic regression model
library(nnet)
library(VGAMdata)
data(xs.nz)
marital.nz <- xs.nz[,c("marital","sex","age","height","weight")]
mydata <- marital.nz[complete.cases(marital.nz),]
fit <- multinom(marital ~ sex + age + height + weight, data = mydata,model=TRUE)
# for multinimial logistic regression, a vector of risk labels needs to be made 
# and provided to the colplot function
outnames=colnames(fitted(fit))
labels=c(paste("Linear predictor for",outnames[-1]),paste
				("Predicted chance of being",outnames))
# visualize the model: more than one plot is generated in the current directory
colplot(fit,coloroptions=3,risklabel=labels,filename="div")


#### Support Vector Machine classifier
\dontrun{
	library(kernlab)
	data(iris)
	levels(iris$Species)[levels(iris$Species)=="setosa"] <- "other"
	levels(iris$Species)[levels(iris$Species)=="virginica"] <- "other"
	names(iris)=c("SL","SW","PL","PW","Species")
# RBF kernel
	model <-ksvm(Species ~ ., data = iris,prob.model=TRUE,kpar=list(0.03),C=10)
# The plot should be based on all training data, so the following code should be used:
	newmodel=preplotperf(model,iris,indy=5,zerolevel="min")
	colplot(newmodel,filename="IRIS2",zerolevel="min",coloroptions=5)
}

}
\author{
Vanya Van Belle
}
\references{
Van Belle V., Van Calster B., \emph{Visualizing risk prediction models}, PLoS ONE, 10(7):e0132614. doi:10.1371/journal.pone.0132614 (2015).

Van Belle V., Van Calster B., Suykens J.A.K., Van Huffel S. and Lisboa P., \emph{Explaining support vector machines: a color based nomogram}, Internal Report 16-27, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016

Van Belle V., Van Huffel S., Timmerman D., Froyman W., Bourne T. and Van Calster B., \emph{A color based nomogram for Multinomial Logistic Regression}, Internal Report 16-28, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016
}
\seealso{
\code{\link{cchart}}, \code{\link{ccchart}}
}

