% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{precisionPlot}
\alias{precisionPlot}
\title{Precision Performance Plot of Qualitative Tests.}
\usage{
precisionPlot(vfp, model.no = NULL, cutoff, prob = c(0.05, 0.5, 0.95),
  col = c("blue", "black", "red"), Cutoff = list(), Title = list(),
  Xlabel = list(), Ylabel = list(), HRLine = list(), Legend = FALSE,
  nclass = -1, BG = "gray90", digits = 3, alpha = 0.15, alpha2 = 0,
  xlim = NULL, col.grid = "white", Nrand = 1e+06)
}
\arguments{
\item{vfp}{(VFP) object modeling imprecision over the measuring range}

\item{model.no}{(integer) specifying the VFP-model to used}

\item{cutoff}{(numeric) specifying one or two cutoff(s), the latter will 
implicitly define an equivical zone with implications on how
'prob' will be interpreted (see 'prob' for details)}

\item{prob}{(numeric) values 0 < x < 1 specifying coverage probability of
an respecitive normal distribution at cutoff, in case of two 
cutoffs all elements of 'prob' < 0.5 will be evaluated in 
regard to cutoff 1, and all 'prob' > 0.5 in regard to cutoff 2}

\item{col}{(character) strings specifying colors of the different distributions,
which will be plotted semi-transparent using 'alpha1' for specifying
the level of transparency (1=opaque, 0=fully transparent)}

\item{Cutoff}{(list) specifying all parameters of the \code{\link{abline}} function.
Vertical lines representing one or two cutoffs can be specified, the
color will be re-used for a label in the upper margin. Set to NULL
to omit.}

\item{Title}{(list) specifying all parameters applicable in function
\code{\link{mtext}} for specifying a main title of the plot}

\item{Xlabel}{(list) specifying all parameters applicable in function
\code{\link{mtext}} for specifying the X-axis label of the plot}

\item{Ylabel}{(list) specifying all parameters applicable in function
\code{\link{mtext}} for specifying the Y-axis label of the plot}

\item{HRLine}{(list) specifying all parameters applicable in \code{\link{lines}}
of the line representing the hit rate developing from 0\% to 100\%}

\item{Legend}{(logical) TRUE = a legend is added to the plot}

\item{nclass}{(integer) number of classes in the histograms representing normal
distributions of imprecision at Cx-concentrations, number<10 will lead
to automatically determining appropriate numbers per histogram (default)}

\item{BG}{(character) string specifying a background color}

\item{digits}{(integer) number of significant digits used to indicated concentrations Cx}

\item{alpha}{(numeric) value 0<=x<=1 specifying the level of transparency of histograms}

\item{alpha2}{(numeric) similar to 'alpha' referring to the coverage probability, i.e. 
setting it to a value < 0 will highlight coverage probabilities in histograms}

\item{xlim}{(numeric) plotting limits in X-direction}

\item{col.grid}{(character) string specifying a color name to be used for the grid providing
orientation in X- and Y-direction}

\item{Nrand}{(integer) specifying the number of data points simulated to represent a normal
distribution}
}
\description{
This function visualizes what is described in the CLSI EP12 guideline
for qualitative test with internal continuous response (ICR). The hit rate,
i.e. the number of measurements deemed to have a certain condition. 
The C5 and C95 concentrations will be derived per default by this function
but it can be set to any set of hit rates.
The histograms representing normal distribution of imprecisions at specific
concentrations will be scaled to nicely fit into the plot, i.e. the area under
the plot will not be equal to 1.
}
\examples{
\dontrun{
# perform variance component analysis
library(VCA)
data(VCAdata1)
# perform VCA-anaylsis
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
# transform list of VCA-objects into required matrix
mat <- getMat.VCA(lst)		# automatically selects "total"
mat
# fit all models batch-wise, the best fitting will be used automatically
res <- fit.vfp(model.no=1:10, Data=mat)
# plot hit and visualize imprecision usign default settings
precisionPlot(res, cutoff=20)
# without normal distribution at cutoff do
precisionPlot(res, cutoff=20, prob=c(.05, .95), col=c("blue", "red"))
# highlight the proportion > cutoff (hit rate) more 
precisionPlot(res, cutoff=20, prob=c(.05, .95), col=c("blue", "red"), alpha2=.5)
# plot with legend
precisionPlot(res, cutoff=20, prob=c(.05, .95), col=c("blue", "red"), alpha2=.5, Legend=TRUE)
# use different probabilities and colors
precisionPlot(res, cutoff=20, prob=c(.05, .95), col="black", alpha2=.3)

# now using two cutoffs, i.e. with equivocal zone
precisionPlot(	res, cutoff=c(17, 19), prob=c(.05, .95), col=c("mediumblue", "red3"), 
					alpha2=.5, HRLine=list(col=c("mediumblue", "red3")))
}

}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
