% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.VEwaningVariant.R
\name{plot}
\alias{plot}
\alias{plot.VEwaningVariant}
\title{Plot Analysis Results}
\usage{
\method{plot}{VEwaningVariant}(x, y, ..., taus = NULL, xlim = NULL, nTau = 20L, ylim = NULL)
}
\arguments{
\item{x}{An object of class VEwaningVariant. The object returned by a call to
veWaningVariant()}

\item{y}{Ignored}

\item{...}{Ignored}

\item{taus}{A numeric vector object or NULL. The tau values at which
estimates are to be calculated. If NULL, a vector of length nTau
spanning the range [lag, maxTau], where maxTau is the maximum tau
identified from the training data; if xlim is specified, 
[xlim[1], xlim[2]] is used instead. Note that all values must lie in the
range [lag, maxTau].}

\item{xlim}{A numeric vector object of length 2 or NULL. The extrema
of the tau values at which estimates
are to be calculated. A vector of length nTau spanning the
range [xlim[1], xlim[2]] is generated. Note that the specified limits must
lie in the range [lag, maxTau]. If taus is specified, this input is ignored.}

\item{nTau}{An integer object. The number of tau values at which
estimates are provided. The default is 20. If taus
is specified, this input is ignored.}

\item{ylim}{A numeric vector object or NULL. The y-axis limits for the plots.
If NULL, the y-axis limits are taken from the estimated values.}
}
\value{
A gg object.
}
\description{
Plot the Estimated Vaccine Efficacy
}
\details{
When the variant under analysis is present only in the unblinded phase or
 only the unblinded phase was included in the analysis, vaccine efficacy
 cannot be estimated. In this case, plot() shows the infection rate at 
 \eqn{\tau}{tau} = \eqn{\ell}{l} divided by the infection rate at 
 \eqn{\tau}{tau}. Recall that \eqn{\tau}{tau} is the time since vaccination,
 and \eqn{\ell}{l} is the period of time required to reach full efficacy
 after the initial vaccination dose.
}
\examples{
data(variantData)

set.seed(1234)

ind <- sample(1:nrow(x = variantData), 2500, FALSE)

# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.

res <- veWaningVariant(data = variantData[ind,], 
                       L = 52,  
                       lag = 6,
                       gFunc = 'piece', 
                       v = c(15,30))

plot(x = res)
}
