% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vbtCvrt.R
\name{vbt2dl}
\alias{vbt2dl}
\title{Convert a vector binary tree to double list}
\usage{
vbt2dl(x)
}
\arguments{
\item{x}{A vector binary tree to be converted.}
}
\value{
Return a double list based on input vector binary tree.
}
\description{
Recover a vector binary tree to double list for easy visualization. Empty layers in vector binary
tree will be marked by the symbol "*" as default.
}
\examples{
#Recover vector binary tree to a double list for easy visualization:
vbt <- dl2vbt(chrvec2dl(colnames(datatest))) #make vector binary tree
vbt2dl(vbt)
}
\seealso{
\code{\link[VBTree:vbtinq]{vbtinq}}, \code{\link[VBTree:vbtsub]{vbtsub}}, \code{\link[VBTree:advbtinq]{advbtinq}},
\code{\link[VBTree:advbtsub]{advbtsub}}, \code{\link[VBTree:trvssubinq]{trvssubinq}}, \code{\link[VBTree:vbt2ts]{vbt2ts}},
\code{\link[VBTree:vbt2arr]{vbt2arr}}.
}
\keyword{Double.List}
\keyword{Vector.Binary.Tree}
