% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_LpS.R
\name{fista.LpS}
\alias{fista.LpS}
\title{A function to solve low rank plus sparse model estimation using FISTA algorithm}
\usage{
fista.LpS(
  A,
  b,
  lambda,
  mu,
  alpha_L = 0.25,
  niter = 100,
  backtracking = TRUE,
  x.true
)
}
\arguments{
\item{A}{A design matrix with size of n by p}

\item{b}{A matrix, (or vector) with size of n by p (or n by 1)}

\item{lambda}{A positive numeric value, indicating the tuning parameter for sparse component}

\item{mu}{A positive numeric value, indicating the tuning parameter for low rank component}

\item{alpha_L}{The constraint coefficient of low rank component, default is 0.25}

\item{niter}{The maximum number of iterations required for FISTA}

\item{backtracking}{A boolean argument, indicating that use backtracking in the FISTA}

\item{x.true}{A p by p matrix, the true model parameter. Only available for simulation.}
}
\value{
A list object, including the followings
\describe{
  \item{sparse.comp}{Estimated sparse component}
  \item{lr.comp}{Estimated low-rank component}
  \item{obj.val}{Values of objective function}
  \item{rel.err}{Relative errors compared with the true model parameters if available}
}
}
\description{
A function to solve low rank plus sparse model estimation
}
\keyword{internal}
