% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{second.step.local}
\alias{second.step.local}
\title{local sreening step (second step).}
\usage{
second.step.local(
  method = "sparse",
  data,
  eta,
  q,
  max.iteration = 1000,
  tol = 10^(-4),
  pts,
  an,
  phi.est.full = NULL,
  blocks = NULL,
  use.BIC = FALSE,
  group.case = "columnwise",
  group.index = NULL
)
}
\arguments{
\item{method}{method: sparse, group sparse}

\item{data}{input data matrix, with each column representing the time series component}

\item{eta}{tuning parameter eta for lasso}

\item{q}{the AR order}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{pts}{the selected break points after the first step}

\item{an}{the neighborhood size a_n}

\item{phi.est.full}{parameter matrix}

\item{blocks}{a vector of blocks}

\item{use.BIC}{use BIC for k-means part}

\item{group.case}{group sparse pattern: columnwise, rowwise.}

\item{group.index}{group index for group sparse case}
}
\value{
A list object, which contains the followings
\describe{
  \item{pts}{a set of selected break point after the second local screening step}
  \item{omega}{the selected Omega value}
}
}
\description{
Perform the local screening to "thin out" redundant break points.
}
\keyword{internal}
