\name{LocalObject}
\alias{LocalObject}
\title{Generate a LocalObject object for Umacs Sampler function}
\description{
Generates an object that is used to initialize an R object
locally in a sampler function generated by Sampler.
Usually a call to this function is not necessary,
since it is implicitly done when the value of a named
parameter in the argument list of \code{Sampler} is
an R object but not a function, numeric object or an
instance of the Umacs class \code{Parameter}.

}
\usage{
LocalObject(x)
}
\arguments{
  \item{x}{ An R object (not a function) }
}
\details{
\code{LocalObject} is to be used only within the \code{Sampler} function call;
the value of the argument (\code{x}) is made available (locally)
in a sampling function that is built using the Umacs function \code{Sampler}.

The name of the parameter that will have the value
(\code{x}) is \emph{not} specified here, but only within the \code{\link{Sampler}} function call.

The components of a parameter vector initialized as \code{Data} parameters
cannot be individually updated using Gibbs and Metropolis updating schemes.

For local \emph{functions}, use the function \code{\link{LocalFunction}} instead.

}
\value{
An object of class \code{\link{LocalObject}},
to be further processed by the Umacs function \code{\link{Sampler}}.

}
\references{Kerman, Jouni. Umacs: A Universal Markov Chain Sampler. Technical report, Columbia University, New York.}
\author{Jouni Kerman <jouni@kerman.com>}
\note{
\code{LocalObject} must be associated with a parameter name.

Components of vector parameters specified to be \code{LocalObject}s cannot be updated,
but those specified to be \code{Data} can be updated.
}
\seealso{
\code{\link{Umacs-package}} for an overview of the Umacs package.

\code{\link{Sampler}} for how to create a sampler function; see the vignette for details.

Package `rv'.

}
\examples{}
\keyword{iteration}
