% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UPMASKdata.R
\name{UPMASKdata}
\alias{UPMASKdata}
\title{Run UPMASK in a data frame}
\usage{
UPMASKdata(dataTable, positionDataIndexes=c(1,2),
photometricDataIndexes=c(3,5,7,9,11,19,21,23,25,27),
photometricErrorDataIndexes=c(4,6,8,10,12,20,22,24,26,28), threshold=1, 
classAlgol="kmeans", maxIter=25, starsPerClust_kmeans=25, nstarts_kmeans=50, 
nRuns=8, runInParallel=FALSE, paralelization="multicore", independent=TRUE, 
verbose=FALSE, autoCalibrated=FALSE, considerErrors=FALSE, 
finalXYCut=FALSE, nDimsToKeep=4, dimRed="PCA", scale=TRUE)
}
\arguments{
\item{dataTable}{a data frame with the data to perform the analysis}

\item{positionDataIndexes}{an array of integers indicating the columns of the data frame containing the spatial position measurements}

\item{photometricDataIndexes}{an array of integers with the column numbers containing photometric measurements (or any other measurement to go into the PCA step)}

\item{photometricErrorDataIndexes}{an array of integers with the column numbers containing the errors of the photometric measurements}

\item{threshold}{a double indicating the thresholding level for the random field analysis}

\item{classAlgol}{a string indicating the type of clustering algorithm to consider. Only k-means is implemented at this moment (defaults to kmeans)}

\item{maxIter}{an integer the maximum amount of iterations of the outer loop before giving up convergence (usually it is not necessary to modify this)}

\item{starsPerClust_kmeans}{an integer with the average number of stars per k-means cluster}

\item{nstarts_kmeans}{an integer the amount of random re-initializations of the k-means clustering method (usually it is not necessary to modify this)}

\item{nRuns}{the total number of individual runs to execute the total number of outer loop runs to execute}

\item{runInParallel}{a boolean indicating if the code should run in parallel}

\item{paralelization}{a string with the type of paralilization to use. the paralelization can be: "multicore" or "MPIcluster". At this moment only "multicore" is implemented (defaults to multicore).}

\item{independent}{a boolean indicating if non-parallel runs should be completely independent}

\item{verbose}{a boolean indicating if the output to screen should be verbose}

\item{autoCalibrated}{a boolean indicating if the number of random field realizations for the clustering check in the position space should be autocalibrated (experimental code, defaults to FALSE).}

\item{considerErrors}{a boolean indicating if the errors should be taken into account}

\item{finalXYCut}{a boolean indicating if a final cut in the XY space should be performed (defaults to FALSE)}

\item{nDimsToKeep}{an integer with the number of dimensions to consider (defaults to 4)}

\item{dimRed}{a string with the dimensionality reduction method to use (defaults to PCA. The only other options are LaplacianEigenmaps or None)}

\item{scale}{a boolean indicating if the data should be scaled and centered}
}
\value{
A data frame with the original data used to run the method and additional columns indicating the classification at each run, as well as a membership probability in the frequentist sense.
}
\description{
\code{UPMASKdata} executes the UPMASK method on a data frame, and returns 
another data frame as output, including the membership analysis result as additional 
columns. 

\code{UPMASKdata} is a method for performing membership assignment in stellar 
clusters. The distributed code is prepared to use photometry and spatial positions, 
but it can take into account other types of data as well. The method is able to take 
into account arbitrary error models (the used must rewrite the 
\code{\link{takeErrorsIntoAccount}} function), and it is unsupervised, data-driven, 
physical-model-free and relies on as few assumptions as possible. The approach followed
for membership assessment is based on an iterative process, dimensionality reduction, 
a clustering algorithm and a kernel density estimation.
}
\examples{
\dontrun{
# Analyse a simulated open cluster using spatial and photometric data 
# Load the data into a data frame
fileNameI <- "oc_12_500_1000_1.0_p019_0880_1_25km_120nR_withcolors.dat"
inputFileName <- system.file("extdata", fileNameI, package="UPMASK")
ocData <- read.table(inputFileName, header=TRUE)

# Example of how to run UPMASK using data from a data frame
# (serious analysis require at least larger nRuns)
posIdx <- c(1,2)
photIdx <- c(3,5,7,9,11,19,21,23,25,27)
photErrIdx <- c(4,6,8,10,12,20,22,24,26,28)

upmaskRes <- UPMASKdata(ocData, posIdx, photIdx, PhotErrIdx, nRuns=2, 
                        starsPerClust_kmeans=25, verbose=TRUE)

# Create a simple raw plot to see the results
pCols <- upmaskRes[,length(upmaskRes)]/max(upmaskRes[,length(upmaskRes)])
plot(upmaskRes[,1], upmaskRes[,2], col=rgb(0,0,0,pCols), cex=0.5, pch=19)

# Clean the environment
rm(list=c("inputFileName", "ocData", "posIdx", "photIdx", "photErrIdx", 
          "upmaskRes", "pCols"))
} 
 
}
\references{
\href{http://dx.doi.org/10.1051/0004-6361/201321143}{Krone-Martins, A. & Moitinho, A., A&A, v.561, p.A57, 2014}
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{cluster,}
\keyword{methods,}
\keyword{multivariate,}
\keyword{nonparametric}
