% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenParetoEst}
\alias{GenParetoEst}
\title{Generalised Pareto distribution estimates from parameters}
\usage{
GenParetoEst(loc, scale, shape, q = NULL, RP = 100, ppy = 1)
}
\arguments{
\item{loc}{location parameter}

\item{scale}{scale parameter}

\item{shape}{shape parameter}

\item{q}{quantile. magnitude of the variable under consideration}

\item{RP}{return period}

\item{ppy}{peaks per year. Default is one}
}
\value{
quantile as a function of RP or vice versa
}
\description{
Estimated quantiles as function of return period (RP) and vice versa, from user input parameters
}
\details{
If the argument q is used, it overrides RP and provides RP as a function of q (magnitude of variable) as opposed to q as a function of RP. The average number of peaks per year argument (ppy) is for the function to convert from the peaks over threshold (POT) scale to the annual scale. For example, if there are 3 peaks per year, the probability associated with the 100-yr return period estimate would be 0.01/3 (i.e. an RP of 300 on the POT scale) rather than 0.01.
}
\examples{
#Get a POT sample, estimate the parameters, and estimate 50-year RP
ThamesPOT <- POTextract(ThamesPQ[,c(1,3)], thresh = 0.90)
GenParetoPars(ThamesPOT$peak)
#Store parameters in an object
Pars <- as.numeric(GenParetoPars(ThamesPOT$peak))
#get estimate of 50-yr flow
GenParetoEst(Pars[1], Pars[2], Pars[3], ppy = 1.867, RP = 50)
#Estimate the RP for a 600m3/s discharge
GenParetoEst(Pars[1], Pars[2], Pars[3], ppy = 1.867, q = 600)
}
\author{
Anthony Hammond
}
