% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_ccle_value.R
\name{vis_ccle_gene_cor}
\alias{vis_ccle_gene_cor}
\title{Visualize CCLE Gene Expression Correlation}
\usage{
vis_ccle_gene_cor(
  Gene1 = "CSF1R",
  Gene2 = "JAK3",
  data_type1 = "mRNA",
  data_type2 = "mRNA",
  cor_method = "spearman",
  use_log_x = FALSE,
  use_log_y = FALSE,
  use_regline = TRUE,
  SitePrimary = "prostate",
  use_all = FALSE,
  alpha = 0.5,
  color = "#000000"
)
}
\arguments{
\item{Gene1}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{Gene2}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{data_type1}{choose gene profile type for the first gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{data_type2}{choose gene profile type for the second gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{cor_method}{correlation method}

\item{use_log_x}{if \code{TRUE}, log X values.}

\item{use_log_y}{if \code{TRUE}, log Y values.}

\item{use_regline}{if \code{TRUE}, add regression line.}

\item{SitePrimary}{select cell line origin tissue.}

\item{use_all}{use all sample, default \code{FALSE}.}

\item{alpha}{dot alpha.}

\item{color}{dot color.}
}
\value{
a \code{ggplot} object
}
\description{
Visualize CCLE Gene Expression Correlation
}
