% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezcor.R
\name{ezcor}
\alias{ezcor}
\title{Run Correlation between Two Variables and Support Group by a Variable}
\usage{
ezcor(
  data = NULL,
  split = FALSE,
  split_var = NULL,
  var1 = NULL,
  var2 = NULL,
  cor_method = "pearson",
  adjust_method = "none",
  use = "complete",
  sig_label = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables}

\item{split}{whether perform correlation grouped by a variable, default is 'FALSE'}

\item{split_var}{a \code{character}, the group variable}

\item{var1}{a character, the first variable in correlation}

\item{var2}{a character, the second variable in correlation}

\item{cor_method}{method="pearson" is the default value. The alternatives to be passed to cor are "spearman" and "kendall"}

\item{adjust_method}{What adjustment for multiple tests should be used? ("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none")}

\item{use}{use="pairwise" will do pairwise deletion of cases. use="complete" will select just complete cases}

\item{sig_label}{whether add symbal of significance. P < 0.001,\verb{***}; P < 0.01,\verb{**}; P < 0.05,\code{*}; P >=0.05,""}

\item{verbose}{if \code{TRUE}, print extra info.}
}
\value{
a \code{data.frame}
}
\description{
Run Correlation between Two Variables and Support Group by a Variable
}
\author{
Yi Xiong
}
