% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkmeans.R
\name{genetic_kmeans}
\alias{genetic_kmeans}
\title{Genetic K-Means Clustering}
\usage{
genetic_kmeans(
  data,
  k,
  population_size = 10,
  mut_probability = 0.5,
  max_generations = 10,
  learn = FALSE,
  waiting = TRUE,
  ...
)
}
\arguments{
\item{data}{a set of observations, presented as a matrix-like object where
every row is a new observation.}

\item{k}{the number of clusters.}

\item{population_size}{the number of individuals in the population.}

\item{mut_probability}{the probability of a mutation occurring.}

\item{max_generations}{the maximum number of iterations allowed.}

\item{learn}{a Boolean determining whether intermediate logs explaining how
the algorithm works should be printed or not.}

\item{waiting}{a Boolean determining whether the intermediate logs should be
printed in chunks waiting for user input before printing the next or not.}

\item{...}{additional arguments passed to \code{\link[proxy:dist]{proxy::dist()}}.}
}
\value{
A kmeans object as returned by the original kmeans function.
}
\description{
Performs Genetic K-Means clustering on a data matrix.
}
\examples{
### Example 1: Simple usage with circles dataset
result1 <- genetic_kmeans(db1[1:20,], 2, learn = TRUE, waiting = FALSE)

### Example 2: Moons dataset with different population size
result2 <- genetic_kmeans(db2[1:20,], 2, population_size = 20,
                         learn = TRUE, waiting = FALSE)

### Example 3: Varying density clusters with different mutation probability
result3 <- genetic_kmeans(db3[1:20,], 3, mut_probability = 0.7,
                         learn = TRUE, waiting = FALSE)

### Example 4: Well-separated clusters with larger population
result5 <- genetic_kmeans(db5[1:20,], 3, population_size = 30,
                         mut_probability = 0.6, learn = TRUE, waiting = FALSE)

### Example 5: Using different parameters combinations
result6 <- genetic_kmeans(db1[1:20,], 2,
                         population_size = 15,
                         mut_probability = 0.8,
                         max_generations = 15,
                         learn = TRUE,
                         waiting = FALSE)

}
\author{
Eduardo Ruiz Sabajanes, \email{eduardo.ruizs@edu.uah.es}
}
