% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTrust.r
\name{.ReadAIRR}
\alias{.ReadAIRR}
\title{Read AIRR file.}
\usage{
.ReadAIRR(airr_file = NULL, verbose = TRUE)
}
\arguments{
\item{airr_file}{character. Path to AIRR file, eg. xx_airr.tsv or xx_barcode_airr.tsv.}

\item{verbose}{logical. Print progress. Default is TRUE}
}
\value{
A VDJ information data.frame
}
\description{
\code{.ReadAIRR} reads an AIRR format file from TRUST4/cellranger results or somewhere else.
It could be xx_airr.tsv or xx_barcode_airr.tsv generated by TRUST4 or airr_rearrangement.tsv generated by 10x cellranger (> 6.0).
(.gz supported)
}
\examples{
airr_file = system.file('extdata', 'TRUST4_airr.tsv.gz', package = 'TrustVDJ')
airr = .ReadAIRR(airr_file = airr_file, verbose = FALSE)
head(airr)

}
