% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Z_CPUE.R
\name{Z_CPUE}
\alias{Z_CPUE}
\title{Estimate Z from CPUE data}
\usage{
Z_CPUE(param, method = "standard", omit_age1 = FALSE)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \code{cohort}: a vector with with a cohort label,
  \item \code{age}: a vector with ages,
  \item \code{CPUE}: a vector with CPUE values;
}}

\item{method}{a character string indicating which assessment method should be used:
\code{"standard"}, \code{"Heincke"}, or \code{"RobsonChapman"}.}

\item{omit_age1}{logical; if \code{TRUE} the first age group is
omitted (Default \code{FALSE}).}
}
\value{
A list with input parameters and a Z value or matrix depending on the method.
}
\description{
Method to estimate the instantaneous total mortality rate (Z) from
   catch per unit of effort (CPUE) data according to standard, Heincke's, or
   Robson & Chapman's method.
}
\details{
In Heincke's and RobsonChapman's method age groups older than 4 are lumped,
  because age groups older than 3 or 4 are said to be hard to seperate (Ricker, 1975).
  Sparre and Venema (1998) recommend to omit the first age group in case it is
  not fully exploited by the fishery.
}
\examples{
# load data
data(synCPUE)

# run model with standard method
Z_CPUE(synCPUE, method = "standard")

# run model with Heincke's method
Z_CPUE(synCPUE, method = "Heincke")

# run model with Robson and Chapman's method
Z_CPUE(synCPUE, method = "RobsonChapman", omit_age1 = TRUE)

}
\references{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.

Sparre, P., Venema, S.C., 1999. Introduction to tropical fish stock assessment.
Part 2. Excercises. \emph{FAO Fisheries Technical Paper}, (306.2, Rev. 2). 94 p.

Ricker, W.E., 1975. Computation and interpretation of biological statistics of fish
populations. \emph{Bull.Fish.Res.Board Can.}, (191):382 p.
}
\keyword{CPUE}
\keyword{Z}
\keyword{function}
\keyword{mortality}
