% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{NJTree}
\alias{NJTree}
\title{Generate a neighbour joining tree}
\usage{
NJTree(dataset, edgeLengths = FALSE, ratio = TRUE, ambig = "mean")
}
\arguments{
\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class \code{phyDat},
whose names correspond to the labels of any accompanying tree.}

\item{edgeLengths}{Logical specifying whether to include edge lengths.}

\item{ambig, ratio}{Settings of \code{ambig} and \code{ratio} to be used when
computing \code{\link[=Hamming]{Hamming()}} distances between sequences.}
}
\value{
\code{NJTree} returns an object of class \code{phylo}.
}
\description{
\code{NJTree()} generates a rooted neighbour joining tree from a phylogenetic
dataset.
}
\examples{
data("Lobo")
NJTree(Lobo.phy)

}
\seealso{
Other tree generation functions: 
\code{\link{ConstrainedNJ}()},
\code{\link{GenerateTree}},
\code{\link{SingleTaxonTree}()},
\code{\link{TreeNumber}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
