% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.multiPhylo.R
\name{as.multiPhylo}
\alias{as.multiPhylo}
\alias{as.multiPhylo.phylo}
\alias{as.multiPhylo.list}
\alias{as.multiPhylo.phyDat}
\alias{as.multiPhylo.Splits}
\title{Convert object to \code{multiPhylo} class}
\usage{
as.multiPhylo(x)

\method{as.multiPhylo}{phylo}(x)

\method{as.multiPhylo}{list}(x)

\method{as.multiPhylo}{phyDat}(x)

\method{as.multiPhylo}{Splits}(x)
}
\arguments{
\item{x}{Object to be converted}
}
\value{
\code{as.multiPhylo} returns an object of class \code{multiPhylo}

\code{as.multiPhylo.phyDat()} returns a list of trees, each corresponding
to the partitions implied by each non-ambiguous character in \code{x}.
}
\description{
Converts representations of phylogenetic trees to an object of the 'ape'
class \code{multiPhylo}.
}
\examples{
as.multiPhylo(BalancedTree(8))
as.multiPhylo(list(BalancedTree(8), PectinateTree(8)))
data('Lobo')
as.multiPhylo(Lobo.phy)
}
