% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Support.R
\name{SplitFrequency}
\alias{SplitFrequency}
\alias{SplitNumber}
\alias{ForestSplits}
\alias{TreeSplits}
\title{Frequency of splits}
\usage{
SplitFrequency(reference, forest)

SplitNumber(tips, tree, tipIndex, powersOf2)

ForestSplits(forest, powersOf2)

TreeSplits(tree)
}
\arguments{
\item{reference}{A tree of class \code{phylo}, a \code{Splits} object.}

\item{forest}{a list of trees of class \code{phylo}, or a \code{multiPhylo} object; or a
\code{Splits} object.}

\item{tips}{Integer vector specifying the tips of the tree within the chosen
split.}

\item{tree}{A tree of class \code{\link{phylo}}.}

\item{tipIndex}{Character vector of tip names, in a fixed order.}

\item{powersOf2}{Integer vector of same length as \code{tipIndex}, specifying a
power of 2 to be associated with each tip in turn.}
}
\value{
\code{SplitFrequency()} returns the number of trees in \code{forest} that
contain each split in \code{reference}.
If \code{reference} is a tree of class \code{phylo}, then the sequence will correspond
to the order of nodes (use \code{ape::nodelabels()} to view).
Note that the three nodes at the root of the tree correspond to a single
split; see the example for how these might be plotted on a tree.
}
\description{
\code{SplitFrequency} provides a simple way to count the number of times that
bipartition splits, as defined by a reference tree, occur in a forest of trees.
}
\details{
If multiple calculations are required, some time can be saved by using the
constituent functions (see examples)
}
\section{Functions}{
\itemize{
\item \code{SplitNumber}: Assign a unique integer to each split

\item \code{ForestSplits}: Frequency of splits in a given forest of trees

\item \code{TreeSplits}: Deprecated. Listed the splits in a given tree.
Use as.Splits instead.
}}

\examples{
forest <- as.phylo(c(1, 10, 10, 100, 1000), nTip = 7)

# Simple, but means counting each split in the forest twice:
tree1Freqs <- SplitFrequency(forest[[1]], forest)
SplitFrequency(forest[[2]], forest)

plot(forest[[1]])
ape::nodelabels(tree1Freqs, node=as.integer(names(tree1Freqs)))

}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
