% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Combinatorics.R, R/pp_info_extra_step.r
\name{NRooted}
\alias{NRooted}
\alias{NUnrooted}
\alias{LnUnrooted}
\alias{LnRooted}
\alias{LnUnrootedSplits}
\alias{NUnrootedSplits}
\alias{LnUnrootedMult}
\alias{NUnrootedMult}
\title{Number of rooted/unrooted trees
These functions return the number of rooted or unrooted trees consistent with a given pattern
of splits.}
\usage{
NRooted(tips)

NUnrooted(tips)

LnUnrooted(tips)

LnRooted(tips)

LnUnrootedSplits(splits)

NUnrootedSplits(splits)

LnUnrootedMult(splits)

NUnrootedMult(splits)
}
\arguments{
\item{tips}{The number of tips.}

\item{splits}{vector listing the number of taxa in each tree bipartition.}
}
\description{
Functions starting N return the number of rooted or unrooted trees, functions starting Ln
provide the log of this number.  Calculations follow Carter et al. 1990, Theorem 2.
}
\section{Functions}{
\itemize{
\item \code{NUnrooted}: Number of unrooted trees

\item \code{LnUnrooted}: Log Number of unrooted trees

\item \code{LnRooted}: Log Number of rooted trees

\item \code{LnUnrootedSplits}: Log number of unrooted trees

\item \code{NUnrootedSplits}: Number of unrooted trees

\item \code{LnUnrootedMult}: Log unrooted mult

\item \code{NUnrootedMult}: Number of unrooted trees (mult)
}}

\examples{
  NRooted(10)
  NUnrooted(10)
  LnRooted(10)
  LnUnrooted(10)
  # Number of trees consistent with a character whose states are 00000 11111 222
  NUnrootedMult(c(5,5,3))

}
\references{
\insertRef{Carter1990}{TreeSearch}

\insertRef{Carter1990}{TreeSearch}
}
\author{
Martin R. Smith
}
