% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{BootstrapTree}
\alias{BootstrapTree}
\title{Bootstrap tree search with inapplicable data}
\usage{
BootstrapTree(tree, dataset, TreeScorer = FitchScore, maxIter, maxHits,
  rooted = TRUE, verbosity = 1, ...)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}, with internal numbering in cladewise order
(use \code{\link{Preorder}(tree)} or (slower) \code{\link{Cladewise}(tree)})}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}}, whose names 
correspond to the labels of any accompanying tree}

\item{TreeScorer}{function by which trees should be scored; default \code{\link{FitchScore}}}

\item{maxIter}{maximum number of iterations to perform in tree search}

\item{maxHits}{number of times to find optimal tree length before stopping tree search}

\item{rooted}{set to FALSE if position of root may change, TRUE if position and composition of
outgroup is fixed}

\item{verbosity}{verbosity of output written to terminal; higher values print more messages}

\item{\dots}{further arguments to pass to \code{TreeScorer} function (e.g. \code{\link{TipsAreColumns}}, \code{dataset})}
}
\value{
A tree that is optimal under a random sampling of the original characters
}
\description{
Bootstrap tree search with inapplicable data
}
