% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tlsTransform}
\alias{tlsTransform}
\title{Simple operations on point cloud objects}
\usage{
tlsTransform(
  las,
  xyz = c("X", "Y", "Z"),
  bring_to_origin = FALSE,
  rotate = FALSE
)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{xyz}{\code{character} vector of length 3 - \code{LAS}' columns to be reassigned as XYZ, respectively.
Use minus signs to mirror an axis` coordinates - more details in the sections below.}

\item{bring_to_origin}{\code{logical} - force point cloud origin to match \code{c(0,0,0)}? If \code{TRUE},
clears the header of the \code{LAS} object.}

\item{rotate}{\code{logical} - rotate the point cloud to align the ground points horizontally (as in \code{\link{tlsRotate}})?}
}
\value{
\code{\link[lidR:LAS]{LAS}} object.
}
\description{
Apply transformations to the XYZ axes of a point cloud.
}
\section{XYZ Manipulation}{


The \code{xyz} argument can take a few different forms. It is useful for shifting axes positions in a point cloud or
to mirror an axis' coordinates. All axes characters can be entered in lower or uppercase and also be preceded
by a minus sign ('-') to reverse its coordinates.
}

\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file)
bbox(tls)
range(tls$Z)

### swap the Y and Z axes
zy = tlsTransform(tls, c('x', 'z', 'y'))
bbox(zy)
range(zy$Z)

### return an upside down point cloud
ud = tlsTransform(tls, c('x', 'y', '-z'))
bbox(ud)
range(ud$Z)
plot(zy)

### mirror all axes, then set the point cloud's starting point as the origin
rv = tlsTransform(tls, c('-x', '-y', '-z'), bring_to_origin=TRUE)
bbox(rv)
range(rv$Z)
}
