% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeTE}
\alias{computeTE}
\alias{te}
\alias{transfer-entropy}
\alias{transferentropy}
\title{Estimate Transfer Entropy.}
\usage{
computeTE(X, Y, embedding, k, method = "MI_diff", epsDistace = -1,
  safetyCheck = FALSE)
}
\arguments{
\item{X}{Numeric vector, Transfer Entropy is calculated to random process X}

\item{Y}{Numeric vector, Transfer Entropy is calculated from random process Y}

\item{embedding}{Numeric, The embedding dimension. Must be positive integer}

\item{k}{Numeric, The k'th neighbor used by the Kraskov estimator. Must be positive integer. Kraskov suggests a value in (1,3)}

\item{method}{String, The method to be used to estimate TE from ("MI_dif","Correlation")}

\item{epsDistace}{Numeric, The distance used for measuring TE in Correlation method, by default it is the average distance calculated in XKY}

\item{safetyCheck}{Logical, For computing TE using "mi_diff" method the data need to be noisy otherwise a crach might happen. This parameter can check if there are any idetical points in the spaces made for this use}
}
\value{
Numeric, The estimated transfer entropy
}
\description{
\code{ComputeTE} Estimate the Transfer Entropy (TE) from one continuous-valued random process to a second process.
}
\details{
A function to calculate Transfer Entropy from random process \eqn{Y} to random process \eqn{X}.
The TE, introduced by Schreiber in 2000, extends the concept of mutual information to provide a
direction-sensitive measure of information flow between two time series. Formally,
the transfer entropy from time series \eqn{Y} to \eqn{X} is given by
\eqn{T_{Y \rightarrow X} = \sum p(x_{n+1},x_n^{(k)},y_n^{(l)}) log \frac{p(x_{n+1} \mid x_n^{(k)}, y_n^{(l)})}{p(x_{n+1} \mid x_n^{(k)})}}
where \eqn{x_{n+1}} is the value of \eqn{X} at time \eqn{n+1}, and \eqn{x_n^{(k)}} (\eqn{y_n^{(l)}}) is
the \eqn{k} (\eqn{l}) lagged values of \eqn{X} (\eqn{Y}) at time \eqn{n}.
The definition of TE assumes \eqn{X} is an Markov process. The  \code{embedding} dimension should
be chosen to match the delay of the Markov process. The TE measures the additional amount of
information \eqn{Y} contains about \eqn{X} over the information contained in the Markov embedding.
Two methods for estimating TE are provided. The first is based on the mutual information distance
\eqn{MI(X_{i+1} | X^{(e) },Y_i) - MI(X_{i+1} | X^{(e)} )}, where \eqn{e} is the embedding dimension.
This approach follows directly from the definition of the TE. Mutual information is estimated using
the k-nearest neighbor approach suggested by Krasvok.
The second method is based on the generalized correlation sum.

Things can go wrong in several ways. First, the random processes must meet the assumption of the TE.
That is, \eqn{X} must represent some form of Markov process whose probability distribution may also be
influenced by \eqn{Y}. A more subtle error can occur when multiple points in \eqn{X^(k)}
(or some of its subspaces) have identical coordinates. This can lead to several points which have
identical distance to a query point, which violates the assumptions of the Kraskov estimator, causing it
to throw an error. The solution in this case is to add some small noise to the measurements \eqn{X} prior
to computing TE.
}
\examples{
## Intitialize two vectors of length 10001
X <- rep(0,10000+1)
Y <- rep(0,10000+1)
## Create two linked random processes. Y is independent of X,
## while X is determined in part by the previous values of Y.
for(i in 1:10000){
 Y[i+1] <- 0.6*Y[i] + rnorm(1)
 X[i+1] <- 0.4*X[i] + 0.6*Y[i] + rnorm(1)
}
X <- X[101:10000]
Y <- Y[101:10000]
## Compute the TE from Y to X
computeTE(X,Y,3,1,"MI_diff")  ## should be circa 0.16
## and from X to Y
computeTE(Y,X,3,1,"MI_diff")  ## should be circa zero
computeTE(X,Y,3,1,"Correlation",0.4)
computeTE(Y,X,3,1,"Correlation",0.4)
}

