% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionCR.R
\name{PredictionCR}
\alias{PredictionCR}
\title{Prediction}
\usage{
PredictionCR(List,NNOut,predict)
}
\arguments{
\item{List}{A list with the following components: trainset, testset, MinMaxFromScaling}

\item{NNOut}{The train model}

\item{predict}{The value to be predicted}
}
\value{
The predicted average speed of the road
}
\description{
This function predicts the average speed of the road.
}
\details{
This function returns the predicted average speed.
}
\examples{
\dontrun{
SpecLink <- loadDataSpecLink("163204843","1", X163204843_1)
x <- fillMissingValues(SpecLink)
datetime <- "2017-01-27 14:00:00" 
newData <- fillMissingDates (x, datetime)
DataList <- loadTrainTest (newData, datetime, "Mean_speed")
List <- PreProcessingLink(DataList)
NNOut <- TrainCR (List,"Mean_speed")
predicted <- PredictionCR(List,NNOut,"Mean_speed")}

}
\seealso{
\code{\link{PreProcessingLink}}, \code{\link{TrainCR}}
}
\author{
Aikaterini Chatzopoulou, Kleanthis Koupidis
}
