% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary_extract_df}
\alias{summary_extract_df}
\title{Summary function that only works with the \code{\link[=extract_xy]{extract_xy()}} extractor.
Extracts a single point from the x,y data.frame by first selecting a row
and then returning the y value for that row}
\usage{
summary_extract_df(df, row_select, col = "y")
}
\arguments{
\item{df}{A data.frame with x and y columns. This is provided automatically
by the package and users don't need to provide this.}

\item{row_select}{An expression that will be pass through to
\code{\link[dplyr:filter]{dplyr::filter()}}. This is a quoted argument so you can refer to the variables
\code{x} and \code{y}}

\item{col}{A column name, either "x" or "y"}
}
\value{
The value in a single cell of the data.frame
}
\description{
Summary function that only works with the \code{\link[=extract_xy]{extract_xy()}} extractor.
Extracts a single point from the x,y data.frame by first selecting a row
and then returning the y value for that row
}
