% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.R
\name{extract_histogram}
\alias{extract_histogram}
\title{Extractor function that calculates statistics for a histogram.}
\usage{
extract_histogram(data, as_hist_dat = TRUE)
}
\arguments{
\item{data}{Provided internally, users don't need to provide this.}

\item{as_hist_dat}{If true return an instance of the
\link[HistDat:HistDat-class]{HistDat::HistDat} class. Otherwise return a 1-D numeric vector.
Default true, as this is strongly recommended to avoid crashing the R
interpreter with large counts in the histogram.}
}
\value{
A single \link[HistDat:HistDat-class]{HistDat::HistDat} instance, or a 1-D numeric vector
}
\description{
Extractor function that calculates statistics for a histogram.
}
\details{
For example this might be relevant for the "Coverage histogram" plot
from Qualimap. By default this returns a \link[HistDat:HistDat-class]{HistDat::HistDat} instance,
which is compatible with most common summary statistics (\code{mean}, \code{quantile}, etc),
so your summary statistic functions can be ordinary R functions.
}
\examples{
report <- load_multiqc(
  system.file("extdata", "HG00096/multiqc_data.json", package = "TidyMultiqc"),
  sections = "plots",
  plot_opts = list(
    `fastqc_per_sequence_quality_scores_plot` = list(
      extractor = extract_histogram,
      summary = list(mean = mean),
      prefix = "quality"
    )
  )
)
}
\seealso{
Other extractors: 
\code{\link{extract_ignore_x}()},
\code{\link{extract_xy}()}
}
\concept{extractors}
