% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap-unnest-tbl.R
\name{bootstrap_unnest_tbl}
\alias{bootstrap_unnest_tbl}
\title{Unnest Tidy Bootstrap Tibble}
\usage{
bootstrap_unnest_tbl(.data)
}
\arguments{
\item{.data}{The data that is passed from the \code{tidy_bootstrap()} function.}
}
\value{
A tibble
}
\description{
Unnest the data output from \code{tidy_bootstrap()}.
}
\details{
This function takes as input the output of the \code{tidy_bootstrap()}
function and returns a two column tibble. The columns are \code{sim_number} and \code{y}

It looks for an attribute that comes from using \code{tidy_bootstrap()} so it will
not work unless the data comes from that function.
}
\examples{
tb <- tidy_bootstrap(.x = mtcars$mpg)
bootstrap_unnest_tbl(tb)

bootstrap_unnest_tbl(tb) \%>\%
  tidy_distribution_summary_tbl(sim_number)

}
\seealso{
Other Bootstrap: 
\code{\link{bootstrap_density_augment}()},
\code{\link{bootstrap_p_augment}()},
\code{\link{bootstrap_p_vec}()},
\code{\link{bootstrap_q_augment}()},
\code{\link{bootstrap_q_vec}()},
\code{\link{bootstrap_stat_plot}()},
\code{\link{tidy_bootstrap}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Bootstrap}
