% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-density.R
\name{tidy_autoplot}
\alias{tidy_autoplot}
\title{Automatic Plot of Density Data}
\usage{
tidy_autoplot(
  .data,
  .plot_type = "density",
  .line_size = 0.5,
  .point_size = 0.5,
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data passed in from a tidy_\code{distribution} function like
\code{tidy_normal()}}

\item{.plot_type}{This is a quoted string like 'density'}

\item{.line_size}{The size param ggplot}

\item{.point_size}{The line size param for ggplot}

\item{.interactive}{A boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return an interactive plotly plot.}
}
\value{
A ggplot or a plotly plot.
}
\description{
This is an autoplotting function that will take in a \code{tidy_}
distribution function and a few arguments, one being the plot type, which is
a quoted string of one of the following:
\itemize{
\item \code{density}
\item \code{quantile}
\item \code{probablity}
\item \code{qq}
}

If the number of simulations exceeds 9 then the legend will not print. The plot
subtitle is put together by the attributes of the table passed to the function.
}
\details{
This function will spit out one of the following plots:
\itemize{
\item \code{density}
\item \code{quantile}
\item \code{probability}
\item \code{qq}
}
}
\examples{
tn <- tidy_normal(.num_sims = 5)
tidy_autoplot(tn, .plot_type = "density", .point_size = .1)

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Autoplot}
