% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_greene.R
\name{t_greene}
\alias{t_greene}
\title{Greene t test of Sexual Dimorphism}
\usage{
t_greene(
  x,
  Pop = 1,
  es = "none",
  plot = FALSE,
  ...,
  alternative = c("two.sided", "less", "greater"),
  padjust = "none",
  letters = FALSE,
  digits = 4,
  CI = 0.95
)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{Pop}{Number of the column containing populations' names, Default: 1}

\item{es}{Type of effect size either "d" for Cohen's d,"g" for Hedge's g
or "none" , Default:"none".}

\item{plot}{Logical; if TRUE graphical matrix of p values, Default: FALSE}

\item{...}{additional arguments that can be passed to
[corrplot][corrplot::corrplot] function.}

\item{alternative}{a character string specifying the alternative
hypothesis, must be one of "two.sided", "greater" or "less".}

\item{padjust}{Method of p.value adjustment for multiple comparisons
following \link[stats]{p.adjust.methods}  Default: "none".}

\item{letters}{Logical; if TRUE returns letters for pairwise comparisons
where significantly different populations are given different letters,
Default: FALSE'}

\item{digits}{Number of significant digits, Default: 4}

\item{CI}{confidence interval coverage takes value from 0 to 1, Default: 0.95.}
}
\value{
data frame of t.test results
}
\description{
Calculation and visualization of the differences in degree
sexual dimorphism between two populations using summary statistics as
input.
}
\details{
The input is a data frame of summary statistics where the column
containing population names is chosen by position (first by default), other
columns of summary data should have specific names (case sensitive) similar
to \link{baboon.parms_df}
}
\examples{
# Comparisons of femur head diameter in four populations
library(TestDimorph)
df <- data.frame(
  Pop = c("Turkish", "Bulgarian", "Greek", "Portuguese "),
  m = c(150.00, 82.00, 36.00, 34.00),
  f = c(150.00, 58.00, 34.00, 24.00),
  M.mu = c(49.39, 48.33, 46.99, 45.20),
  F.mu = c(42.91, 42.89, 42.44, 40.90),
  M.sdev = c(3.01, 2.53, 2.47, 2.00),
  F.sdev = c(2.90, 2.84, 2.26, 2.90)
)
t_greene(
  df,
  plot = TRUE,
  method = "ellipse",
  padjust = "none",
  type = "lower",
  col = c(
    "#AEB6E5",
    "#B1A0DB",
    "#B788CD",
    "#BC6EB9",
    "#BC569E",
    "#B6407D",
    "#A93154"
  ),
  tl.cex = 0.8,
  tl.col = "black",
  insig =
    "label_sig",
  tl.srt = 0.1,
  pch.cex = 2.5,
  tl.pos = "ld",
  win.asp = 1,
  number.cex = 0.5,
  na.label = "NA"
)
}
\seealso{
[multcompView::multcompLetters()]
[corrplot::corrplot()]
}
