% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMimpute.r
\name{EMimpute}
\alias{EMimpute}
\title{EM Imputation}
\usage{
EMimpute(test.data, Mvalue = "NA", max.score = 1, round.decimal = 0)
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}

\item{max.score}{The max possible response value in the test data. By default max.score=1 (i.e.,binary test data).}

\item{round.decimal}{The number of digits or decimal places for the imputed value. The default value is 0.}
}
\value{
A data frame with all missing responses replaced by integrated imputed values.
}
\description{
This function imputes for all missing responses using EM imputation (see Finch, 2008) 
<doi: 10.1111/j.1745-3984.2008.00062.x>.
Integrated scores are obtained by rounding imputed values to the closest possible response value.
}
\examples{
 
        EMimpute(test.data, Mvalue="NA",max.score=1,round.decimal=0)
}
\references{
{
 Finch, H. (2008).
"Estimation of Item Response Theory Parameters in the Presence of Missing Data."
 Journal of Educational Measurement, 45(3), 225-245. doi: 10.1111/j.1745-3984.2008.00062.x. 
}
}
