% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputeTestData.r
\name{ImputeTestData}
\alias{ImputeTestData}
\title{This main function imputes for missing responses using selected method}
\usage{
ImputeTestData(test.data, Mvalue = "NA", max.score = 1,
  method = "LW")
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}

\item{max.score}{The max possible response value in test data. By default max.score=1 (i.e.,binary test data).}

\item{method}{Missing response imputation methods. "LW" (by default) represents listwise that deletes all examinees
who reported missing responses; "IN" means treating all missing responses as incorrect; "PM" imputes for 
all missing responses of an examinee by his/her mean on the available items; "IM" imputes for all missing responses 
of an item by its mean on the available responses; "TW" imputes for all missing responses using two-way 
imputation (if an examinee has no response to all items, the missing responses 
are replaced by item means first).; "LR" imputes for all missing responses using logistic regression; "EM" imputes 
for all missing responses using EM imputation.}
}
\value{
A data frame with all missing responses replaced by integrated imputed values.
}
\description{
This function imputes for all missing responses using selected miputation methods.
Integrated scores are obtained by rounding imputed values to the closest possible response value.
}
\examples{
 
        ImputeTestData(test.data, Mvalue="8",max.score=1, method ="TW")
}
