% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_stat.R
\name{whichCor}
\alias{whichCor}
\title{Returns the indexes of an upper triangular matrix with logical entries.}
\usage{
whichCor(mat)
}
\arguments{
\item{mat}{A matrix with logical entries in the upper triangular part}
}
\value{
Returns the indexes of the upper triangular part where the entries are TRUE
}
\description{
Returns the indexes of an upper triangular matrix with logical entries.
}
\examples{
n <- 100
p <- 10
corr_theo <- diag(1,p)
corr_theo[1,3] <- 0.5
corr_theo[3,1] <- 0.5
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
res <- ApplyFwerCor(data,stat_test='empirical',method='Bonferroni',stepdown=FALSE)
# significant correlations, level alpha:
alpha <- 0.05
whichCor(res<alpha)
}
