% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalT.R
\name{fit_ordinal}
\alias{fit_ordinal}
\title{Main function for parametric tensor estimation and completion based on ordinal observations.}
\usage{
fit_ordinal(ttnsr,r,omega=TRUE,alpha = TRUE)
}
\arguments{
\item{ttnsr}{A given (possibly noisy and incomplete) data tensor. The function allows binary- and ordinal-valued tensors. Missing value should be encoded as \code{NA}.}

\item{r}{A rank to be fitted (Tucker rank).}

\item{omega}{The cut-off points if known,

\code{omega = TRUE} if unknown.}

\item{alpha}{A signal level

\code{alpha = TRUE} if the signal level is unknown.}
}
\value{
A list containing the following:

\code{C} - An estimated core tensor.

\code{A} - Estimated factor matrices.

\code{theta} - An estimated latent parameter tensor.

\code{iteration} - The number of iterations.

\code{cost} - Log-likelihood value at each iteration.

\code{omega} - Estimated cut-off points.
}
\description{
Estimate a signal tensor from a noisy and incomplete ordinal-valued tensor using the cumulative logistic model.
}
\examples{
# Latent parameters
library(tensorregress)
alpha = 10
A_1 = matrix(runif(10*2,min=-1,max=1),nrow = 10)
A_2 = matrix(runif(10*2,min=-1,max=1),nrow = 10)
A_3 = matrix(runif(10*2,min=-1,max=1),nrow = 10)
C = as.tensor(array(runif(2^3,min=-1,max=1),dim = c(2,2,2)))
theta = ttm(ttm(ttm(C,A_1,1),A_2,2),A_3,3)@data
theta = alpha*theta/max(abs(theta))
adj = mean(theta)
theta = theta-adj
omega = c(-0.2,0.2)+adj

# Observed tensor
ttnsr <- realization(theta,omega)@data

# Estimation of parameters
ordinal_est = fit_ordinal(ttnsr,c(2,2,2),omega = TRUE,alpha = 10)

}
\references{
C. Lee and M. Wang. Tensor denoising and completion based on ordinal observations. \emph{International Conference on Machine Learning (ICML)}, 2020.
}
