% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fitting.R
\name{fitParaSurv}
\alias{fitParaSurv}
\title{Fit Parametric Survival Distribution}
\usage{
fitParaSurv(time, status, dist = "weibull", sig = 0.05, init = NULL,
  eps = 1e-06, maxit = 10, report = F)
}
\arguments{
\item{time}{Observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if
censored.}

\item{dist}{Distribution to fit, selected from among: exp, gamma, gengamma,
log-logistic, log-normal, and weibull.}

\item{sig}{Significance level, for CIs.}

\item{init}{List of initial parameter values. See individual distributions for
naming convention.}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{fit} containing the following:
\describe{
  \item{Parameters}{The estimated shape and rate parameters.}
  \item{Information}{The observed information matrix.}
  \item{Outcome}{The fitted mean, median, and variance.}
}
}
\description{
Estimates parametric survival distributions using event times subject to
non-informative right censoring. Available distributions include:
exponential, gamma, generalized gamma, log-logistic, log-normal, and Weibull.
}
\examples{
# Generate cenored gamma data
D = rGamma(n=1e3,a=2,l=2,p=0.2);
# Fit gamma distribution
M = fitParaSurv(time=D$time,status=D$status,dist="gamma");

# Generate cenored weibull data
D = rWeibull(n=1e3,a=2,l=2,p=0.2);
# Fit weibull distribution
M = fitParaSurv(time=D$time,status=D$status,dist="weibull");
}
\seealso{
\itemize{
  \item{Between group comparison of survival experience \code{\link{compParaSurv}}}
  \item{Exponential distribution \code{\link{fit.Exp}}}
  \item{Gamma distribution \code{\link{fit.Gamma}}}
  \item{Generalized gamma distribution \code{\link{fit.GenGamma}}}
  \item{Log-logistic distribution \code{\link{fit.LogLogistic}}}
  \item{Log-normal distribution \code{\link{fit.LogNormal}}}
  \item{Weibull distribution \code{\link{fit.Weibull}}}
}
}
