% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_HDx_HmDm_HT.f.R
\name{E_HDx_HmDm_HT.f}
\alias{E_HDx_HmDm_HT.f}
\title{Estimate height of given diameter}
\usage{
E_HDx_HmDm_HT.f(
  Dx,
  Hm,
  Dm,
  mHt,
  sHt = 0,
  par.lme,
  Rfn = list(fn = "sig2"),
  ...
)
}
\arguments{
\item{Dx}{Scalar. Diameter for which to return height.}

\item{Hm}{Numeric vector of stem heights (m) along which diameter 
measurements were taken for calibration. Can be of length 1. Must be of same 
length as \code{Dm}.}

\item{Dm}{Numeric vector of diameter measurements (cm) taken for calibration.
Can be of length 1. Must be of same length as \code{Hm}.}

\item{mHt}{Scalar. Tree height (m).}

\item{sHt}{Scalar. Standard deviation of stem height. Can be 0 if height was 
measured without error.}

\item{par.lme}{List of taper model parameters obtained by 
\code{\link{TapeR_FIT_LME.f}}.}

\item{Rfn}{list with function name to provide estimated or assumed residual 
variances for the given measurements, optionally parameters for such functions}

\item{...}{not currently used}
}
\value{
A scalar. Estimated height (m) given a diameter.
}
\description{
Calibrates a taper curve based on at least one diameter 
measurement and returns the height of a given diameter
}
\details{
returns the height given a certain diameter.
}
\examples{
# example data
data(DxHx.df)
# taper curve parameters based on all measured trees
data(SK.par.lme)

#select data of first tree
Idi <- (DxHx.df[,"Id"] == unique(DxHx.df$Id)[1])
(tree1 <- DxHx.df[Idi,])

## Predict the taper curve based on the diameter measurement in 2 m
## height and known height 
tc.tree1 <- E_DHx_HmDm_HT.f(Hx=1:tree1$Ht[1], 
                            Hm=tree1$Hx[3],
                            Dm=tree1$Dx[3], 
                            mHt = tree1$Ht[1], 
                            sHt = 0, 
                            par.lme = SK.par.lme)
#plot the predicted taper curve
plot(tc.tree1$Hx, tc.tree1$DHx, type="l", las=1)

## Calculate the height given a certain diameter threshold, say 8.5 cm
ht.tree1.d8.5 <- E_HDx_HmDm_HT.f (Dx=8.5, 
                                  Hm=tree1$Hx[3],
                                  Dm=tree1$Dx[3], 
                                  mHt = tree1$Ht[1], 
                                  sHt = 1, 
                                  par.lme = SK.par.lme,
                                  Rfn=list(fn="sig2")) 
# add to plot
points(x=ht.tree1.d8.5, y=8.5, pch=8, col=2, cex=2)

}
\references{
Kublin, E., Breidenbach, J., Kaendler, G. (2013) A flexible stem 
taper and volume prediction method based on mixed-effects B-spline 
regression, Eur J For Res, 132:983-997.
}
\seealso{
\code{\link{TapeR_FIT_LME.f}}
}
\author{
Edgar Kublin
}
