% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableHC.R
\name{tables.pval}
\alias{tables.pval}
\title{Binomial p-values of Two-Tables}
\usage{
tables.pval(tb1, tb2)
}
\arguments{
\item{tb1}{A one-way table with integer counts.}

\item{tb2}{A one-way table with integer counts.}
}
\value{
table of pair of counts per feature and a p-value 
associated with each pair.
}
\description{
Align tables and compute p-values of features using a 
binomial allocation model. Use outer mergeing and fill
missing values with zeros.
}
\examples{
tb1 = table(c(1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,6,6,7,7,7))
tb2 = table(c(1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,4,4,4,5,5,5,6))
PV = tables.pval(tb1, tb2) # compute P-values 
HC.vals(PV$pv)  # combine P-values using the HC statistics

text1 = "But our fish said, No ! No ! Make that cat go away ! 
           Tell that Cat in the Hat You do NOT want to play . 
           He should not be here . He should not be about . 
         He should not be here When your mother is out !"
text2 = "Now ! Now ! Have no fear . Have no fear! said the cat . 
           My tricks are not bad , Said the Cat in the Hat . Why , 
            we can have Lots of good fun, if you wish, with a game
             that I call UP - UP - UP with a fish !"

tb1 = table(strsplit(tolower(text1),' '))
tb2 = table(strsplit(tolower(text2),' '))
pv = tables.pval(tb1,tb2)
HC.vals(pv$pv)


}
