% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_testing.R
\name{compute_B_pT}
\alias{compute_B_pT}
\title{Compute \eqn{B_{pT}} Statistic for Covariance Time-Variation Hypothesis Testing}
\usage{
compute_B_pT(local_factors, global_factors, residuals, h, iT, ip, kernel_func)
}
\arguments{
\item{local_factors}{A list where each element is a numeric matrix representing the
local factor scores for a specific time period. Each matrix should have \eqn{T} rows
(time periods) and \eqn{m} columns (factors).}

\item{global_factors}{A numeric matrix of global factor scores with \eqn{T} rows
(time periods) and \eqn{m} columns (factors).}

\item{residuals}{A numeric matrix of residuals with \eqn{T} rows (time periods) and \eqn{p} columns (assets).}

\item{h}{A numeric value indicating the bandwidth parameter for the kernel function.}

\item{iT}{An integer specifying the number of time periods.}

\item{ip}{An integer specifying the number of assets.}

\item{kernel_func}{A function representing the kernel used for weighting. Typically, an
Epanechnikov kernel or another boundary kernel function.}
}
\value{
A numeric scalar \eqn{B_{pT}} representing the computed statistic based on
kernel-weighted factor interactions and residuals.
}
\description{
This function calculates the \eqn{B_{pT}} statistic, which is part of the hypothesis
testing procedure to determine whether the covariance matrix of asset returns is time-varying.
It incorporates kernel-weighted local and global factor interactions along with residuals.
}
\details{
The function performs the following steps:
\enumerate{
  \item Computes the sum of squared residuals for each time period \eqn{s}.
  \item Constructs the kernel matrix \eqn{K[s,t]} by applying the \code{boundary_kernel}
  function to each pair of time periods \eqn{(s,t)}.
  \item Calculates the local dot-product matrix \eqn{L[s,t]} as the dot product between
  the local factors at time \eqn{s} and \eqn{t}.
  \item Computes the global dot-product matrix \eqn{G[s,t]} as the dot product between
  the global factors at time \eqn{s} and \eqn{t}.
  \item Computes the element-wise squared difference between \eqn{K * L} and \eqn{G},
  multiplies it by the residuals, and sums over all \eqn{s,t}.
  \item Scales the aggregated value by \eqn{\frac{\sqrt{h}}{T^2 \sqrt{p}}} to obtain \eqn{B_{pT}}.
}
}
\keyword{internal}
