% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluating.r
\name{evaluating}
\alias{evaluating}
\alias{fitness}
\alias{error}
\title{Prediction/modeling quality evaluation}
\usage{
evaluating(eval_func, eval_par = NULL, ..., subclass = NULL)

fitness(eval_func, eval_par = NULL, ..., subclass = NULL)

error(eval_func, eval_par = NULL, ..., subclass = NULL)
}
\arguments{
\item{eval_func}{A function for computing a particular metric.}

\item{eval_par}{List of named parameters required by \code{eval_func}.}

\item{...}{Other parameters to be encapsulated in the class object.}

\item{subclass}{Name of new specialized subclass object created in case it is provided.}
}
\value{
An object of class \code{evaluating}. A list usually containing at least
the following elements: \item{func}{A function for computing a particular metric.}
\item{par}{Particular parameters required by \code{func}.}
}
\description{
Constructor for the \code{evaluating} class representing a time series prediction
or modeling fitness quality evaluation based on a particular metric.
The \code{evaluating} class has two specialized subclasses \code{fitness} and 
\code{error} reagarding fitness criteria and prediction/modeling error metrics, respectively.
}
\examples{

e <- error(eval_func=TSPred::NMSE, eval_par=list(train.actual=NULL),
           method="Normalised Mean Squared Error", subclass="NMSE")
summary(e)

f <- fitness(eval_func=stats::AIC, method="Akaike's Information Criterion", subclass="AIC")
summary(f)

}
\seealso{
Other constructors: 
\code{\link{ARIMA}()},
\code{\link{LT}()},
\code{\link{MSE_eval}()},
\code{\link{modeling}()},
\code{\link{processing}()},
\code{\link{tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{constructors}
\keyword{evaluation}
\keyword{metric}
\keyword{quality}
