
## helper
.TSPLIB_fix_inf <- function(x, inf = NULL, neg_inf = NULL) {
    ## fixes for TSPLIB
    ## replace Inf by a large pos. number and -Inf by a large neg. number
    max_wo_inf <- max(abs(x[is.finite(x)])) 
    
    posInf_index <- x == Inf
    if(any(posInf_index)) {
        posInf <- if(is.null(inf)) 2 * max_wo_inf else inf

        cat("Pos. infinity values are replaced by", posInf, "\n")
        x[posInf_index] <- posInf
    }

    negInf_index <- x == -Inf
    if(any(negInf_index)) {
        negInf <- if(is.null(neg_inf)) -2 * max_wo_inf else neg_inf

        cat("Neg. infinity values are replaced by", negInf, "\n")
        x[negInf_index] <- negInf
    }
    x
}


## write a simple TSPLIB format file from an object of class TSP
## (contains a dist object or a symmetric matrix) 

write_TSPLIB.TSP <- function(x, file, precision = 6, inf = NULL, neg_inf = NULL) {
  
    ## Concorde can handle UPPER_ROW and dist (lower triangle matrix) 
    ## is symmetric.
    format <- "EDGE_WEIGHT_FORMAT: UPPER_ROW"
    
    zz <- file(file, "w")

    cat("NAME: tsp",
        "COMMENT: generated by write_TSPLIB (R package tsp)",
        "TYPE: TSP",
        paste("DIMENSION:", n_of_cities(x)),
        "EDGE_WEIGHT_TYPE: EXPLICIT",
        format, 
        file = zz, sep = "\n")
    
    
    ## fix infinity values
    if(any(is.infinite(x))) x <- .TSPLIB_fix_inf(x, inf, neg_inf)
    
    ## only integers can be used as weights
    if(storage.mode(x) != "integer") x <- as.integer(x * 10^precision)
    
    if(any(is.na(x))) stop("integer overflow, please reduce precision.")


    cat("EDGE_WEIGHT_SECTION", x, file = zz, sep = "\n")
    cat("EOF", file = zz, sep = "\n")

    close(zz)
}

write_TSPLIB.ATSP <- function(x, file, precision = 6, inf = NULL, neg_inf = NULL) {
    format <- "EDGE_WEIGHT_FORMAT: FULL_MATRIX"
    
    zz <- file(file, "w")

    cat("NAME: tsp",
        "COMMENT: generated by write_TSPLIB (R package tsp)",
        "TYPE: ATSP",
        paste("DIMENSION:", n_of_cities(x)),
        "EDGE_WEIGHT_TYPE: EXPLICIT",
        format, 
        file = zz, sep = "\n")
    
    
    ## fix infinity values
    if(any(is.infinite(x))) x <- .TSPLIB_fix_inf(x, inf, neg_inf)
    
    ## only integers can be used as weights
    if(storage.mode(x) != "integer") x <- as.integer(x * 10^precision)
    
    if(any(is.na(x))) stop("integer overflow, please reduce precision.")

    cat("EDGE_WEIGHT_SECTION", x, file = zz, sep = "\n")
    cat("EOF", file = zz, sep = "\n")

    close(zz)
}

## generic
write_TSPLIB <- function(x, file, precision = 6, inf = NULL, neg_inf = NULL) 
    UseMethod("write_TSPLIB")

