% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discriminant.R
\name{LOOCV.WaveAnalysis}
\alias{LOOCV.WaveAnalysis}
\title{LOOCV}
\usage{
\method{LOOCV}{WaveAnalysis}(data, grps, method, returnClassification = FALSE, ...)
}
\arguments{
\item{data}{WaveAnalysis object obtained with MultiWaveAnalysis and
preferably obtained a subset of its characteristics
(\code{\link{StepDiscrim}}, \code{\link{StepDiscrimV}})}

\item{grps}{Labeled vector that classify the observations.}

\item{method}{Selected method for discrimination. Valid options
"linear" "quadratic"}

\item{returnClassification}{Allows to select if the raw result classification
is returned.}

\item{...}{Additional arguments}
}
\value{
\itemize{
\item if returnClassification is false return a object of class
confusionMatrix
\item if returnClassification is true, it returns a list containing an
object of the confusionMatrix class and a vector with the
classification result.
}
}
\description{
Performs a leave-one-cross-validation (LOOCV) method on a WaveAnalysis
object. It is advisable to have selected a subset of all features
(\code{\link{StepDiscrim}},\code{\link{StepDiscrimV}})
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
MWA <- MultiWaveAnalysis(ECGExample, "haar", features = c("var"))
MWADiscrim <- StepDiscrim(MWA, c(rep(1, 5), rep(2, 5)), 5,
                          features = c("var"))
CM <- LOOCV(MWADiscrim, c(rep(1, 5), rep(2, 5)), "linear")
}

}
\seealso{
\itemize{
\item \code{\link{LOOCV}}
\item \code{\link{LOOCV.array}}
\item \code{\link{StepDiscrim}}
\item \code{\link{StepDiscrimV}}
}
}
